#include "../bdtypes.h"
#include "../bdfunc.h"
#include "../bdglobal.h"
#include "../generator.h"

#define NB_BALLS (40)

static Obj3d *pSol;
static Obj3d *pLights, *pLights2;
static Obj3d *pBoules;

static float Matrix[16];
static float Matrix2[16];
static float MatrixB[16];
static float MatrixB2[16];

static Vector BoulesPos[NB_BALLS];
static Vector BoulesDir[NB_BALLS];

static FbVertex pVertexIn[] =
{
	{-50,-10,-50,  0.f,0,0,   0,0,0.f, {0.f, 0.f, 0.f}},
	{50,-10,-50,  0.f,0,0,   0,0,0.f, {256.f, 0.f, 0.f}},
	{50,-10,50,  0.f,0,0,   0,0,0.f, {256.f, 256.f, 0.f}},
	{-50,-10,50,  0.f,0,0,   0,0,0.f, {0.f, 256.f, 0.f}},

	{-50,-40,-50,  0.f,0,0,   0,0,0.f, {256.f, 256.f, 0.f}},
	{50,-40,-50,  0.f,0,0,   0,0,0.f, {0.f, 256.f, 0.f}},
	{50,-40,50,  0.f,0,0,   0,0,0.f, {0.f, 0.f, 0.f}},
	{-50,-40,50,  0.f,0,0,   0,0,0.f, {256.f, 0.f, 0.f}},
};
static GrVertex pVertexOut[sizeof(pVertexIn)/sizeof(FbVertex)];

static Face pFace[] =
{
	{0,1,2},
	{2,3,0},
	{4,5,6},
	{6,7,4},

	{0,1,5},
	{5,4,0},

	{1,2,6},
	{6,5,1},

	{2,3,7},
	{7,6,2},

	{3,0,4},
	{4,7,3},
};

static Obj3d p2Spot = 
{
	pVertexIn,
	pVertexOut,
	sizeof(pVertexIn)/sizeof(FbVertex), // Nb Vertexes
	pFace,
	sizeof(pFace)/sizeof(Face)
};

static float Matrix[16], Matrix2[16];

void LInit_2spot()
{
	int Cpt1;

	pSol = GenerateFloor(10, 10, 800, 800, 2048, 2048);
	BeIdentityMatrix(Matrix);
	//RotateXMatrix(Matrix2, Matrix, -PI/2);
	RotateXMatrix(Matrix2, Matrix, -cos_size/4);
	ApplyMatrix(pSol, Matrix2);

	pLights = GenerateCylinder(10, 2, 20, 400, 256, 256);
	BeIdentityMatrix(Matrix);
	TranslateMatrix(Matrix, 0, -450, 0);
	RotateXMatrix(Matrix2, Matrix, cos_size/4);
	ApplyMatrix(pLights, Matrix2);

	pLights2 = CopyObj(pLights);
	BeIdentityMatrix(Matrix);
	RotateYMatrix(Matrix2, Matrix, cos_size/4);
	ApplyMatrix(pLights2, Matrix2);
	pLights = CombineObj(pLights, pLights2);
	DeleteObj(pLights2);

	pLights2 = CopyObj(pLights);
	BeIdentityMatrix(Matrix);
	RotateYMatrix(Matrix2, Matrix, cos_size/2);
	ApplyMatrix(pLights2, Matrix2);
	pLights = CombineObj(pLights, pLights2);
	DeleteObj(pLights2);

	BeIdentityMatrix(Matrix);
	TranslateMatrix(Matrix, 0, -20, 0);
	ApplyMatrix(pLights, Matrix);

	pBoules = GenerateSphere(5, 5, 20, 20, 256, 256);

	for(Cpt1=0;Cpt1<NB_BALLS;Cpt1++)
	{
		BoulesDir[Cpt1].x = (float)cos(PI2*Cpt1/(float)NB_BALLS);
		BoulesDir[Cpt1].z = (float)sin(PI2*Cpt1/(float)NB_BALLS);
		BoulesPos[Cpt1].x = BoulesDir[Cpt1].x * 500 / (float)NB_BALLS * Cpt1;
		BoulesPos[Cpt1].z = BoulesDir[Cpt1].z * 500 / (float)NB_BALLS * Cpt1;
	}

	PrepareTextureFromArray(g_PicCiel, 256, 256, &g_TextureCiel);
	PrepareTextureFromArray(g_PicGround, 256, 256, &g_TextureGround);
}

void QInit_2spot()
{
	grDepthBufferMode(GR_DEPTHBUFFER_WBUFFER);
	grDepthBufferFunction(GR_CMP_LESS);
	grAlphaCombine(GR_COMBINE_FUNCTION_BLEND_OTHER, GR_COMBINE_FACTOR_ONE,
					GR_COMBINE_LOCAL_NONE, GR_COMBINE_OTHER_CONSTANT, FXFALSE);
	grAlphaBlendFunction(GR_BLEND_ONE, GR_BLEND_ZERO, GR_BLEND_ZERO, GR_BLEND_ZERO);

	grColorCombine(GR_COMBINE_FUNCTION_SCALE_OTHER,
					GR_COMBINE_FACTOR_ONE,
					GR_COMBINE_LOCAL_ITERATED, GR_COMBINE_OTHER_TEXTURE, FXFALSE);

	grChromakeyMode(GR_CHROMAKEY_DISABLE);
	grCullMode(GR_CULL_DISABLE);
	grFogMode(GR_FOG_DISABLE);

	DownloadTexture(&g_TextureCiel);
	DownloadTexture(&g_TextureGround);

	grConstantColorValue((64<<24)+(255<<16)+(255<<8)+255);
}

void Effect_2spot()
{
	static DWORD nOld = 0;
	long Fade;
	DWORD Progress;
	float fTmp, HeightTmp;
	DWORD Cpt1;
	int x, z;

	Fade = 255-((DWORD)(g_demostate.TickInEffect)>>2)&255;
	Fade = Fade*3/4 + 64;
	if (Fade<0)
		Fade = 0;
	grConstantColorValue(((Fade/2)<<24)+(Fade<<16)+(Fade<<8)+Fade);

	Progress = (g_demostate.TickInEffect - nOld)/2;

	/*fTmp = PI/(2.5f+0.25f*(float)cos(g_demostate.TickInEffect/700.f));*/
	fTmp = 4096/(2.5f+0.25f*(float)cos(g_demostate.TickInEffect/700.f));
	HeightTmp = 400+50*(float)cos(g_demostate.TickInEffect/500.f);

	grAlphaBlendFunction(GR_BLEND_ONE, GR_BLEND_ZERO, GR_BLEND_ZERO, GR_BLEND_ZERO);
	grColorCombine(GR_COMBINE_FUNCTION_SCALE_OTHER,
					GR_COMBINE_FACTOR_LOCAL,
					GR_COMBINE_LOCAL_CONSTANT, GR_COMBINE_OTHER_TEXTURE, FXFALSE);
	BeIdentityMatrix(Matrix);
	RotateYMatrix(Matrix2, Matrix, g_demostate.TickInEffect);
	RotateXMatrix(Matrix, Matrix2, fTmp);
	TranslateMatrix(Matrix, 0,0, HeightTmp);
	SelectTexture(g_TextureGround);
	grDepthBufferFunction(GR_CMP_ALWAYS);
	grDepthMask(FXFALSE);
	DrawWithMatrix(pSol, Matrix, false, NULL, 0);
	grDepthMask(FXTRUE);
	grDepthBufferFunction(GR_CMP_LESS);

	BeIdentityMatrix(Matrix);
	RotateYMatrix(Matrix2, Matrix, g_demostate.TickInEffect*-5);
	RotateXMatrix(Matrix, Matrix2, fTmp);
	TranslateMatrix(Matrix, 0,0, HeightTmp);
	SelectTexture(g_TextureCiel);
	DrawWithMatrix(&p2Spot, Matrix, false, NULL, 0);

	// draw the _boules_

	SelectTexture(g_TextureCiel);
	grAlphaBlendFunction(GR_BLEND_SRC_ALPHA, GR_BLEND_ONE_MINUS_SRC_ALPHA, GR_BLEND_ZERO, GR_BLEND_ZERO);

	for(Cpt1=0;Cpt1<NB_BALLS;Cpt1++)
	{
		x = (int)BoulesPos[Cpt1].x;
		z = (int)BoulesPos[Cpt1].z;

		if (( x * x + z * z)>240000)
		{
			(int)BoulesPos[Cpt1].x = 0;
			(int)BoulesPos[Cpt1].z = 0;
		}

		BoulesPos[Cpt1].x += BoulesDir[Cpt1].x * Progress;
		BoulesPos[Cpt1].z += BoulesDir[Cpt1].z * Progress;
	
		BeIdentityMatrix(MatrixB);
		TranslateMatrix(MatrixB, BoulesPos[Cpt1].x, 0, BoulesPos[Cpt1].z);
		//RotateXMatrix(MatrixB2, MatrixB, fTmp);
		RotateXMatrix(MatrixB2, MatrixB, fTmp);
		TranslateMatrix(MatrixB2, 0,0, HeightTmp);
		DrawWithMatrix(pBoules, MatrixB2, false, NULL, 0);
	}


	// draw the spots

	grAlphaBlendFunction(GR_BLEND_SRC_ALPHA, GR_BLEND_ONE_MINUS_SRC_ALPHA, GR_BLEND_ZERO, GR_BLEND_ZERO);
	grColorCombine(GR_COMBINE_FUNCTION_LOCAL,
					GR_COMBINE_FACTOR_ONE,
					GR_COMBINE_LOCAL_CONSTANT, GR_COMBINE_OTHER_TEXTURE, FXFALSE);
	DrawWithMatrix(pLights, Matrix, false, NULL, 0);

	nOld = g_demostate.TickInEffect;
}

void ByeBye_2spot()
{
	FreeTexture(&g_TextureGround);
	FreeTexture(&g_TextureCiel);
}